<?php
require_once '../vendor/autoload.php';

use TCPDF;

// Check if form was submitted
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: index.php');
    exit;
}

// Get form data
$data = $_POST['data'] ?? '';
$ora = $_POST['ora'] ?? '';
$locul = $_POST['locul'] ?? '';
$tipul_procesului = $_POST['tipul_procesului'] ?? '';
$obiectul = $_POST['obiectul'] ?? '';
$participanti = $_POST['participanti'] ?? '';
$concluzii = $_POST['concluzii'] ?? '';
$semnatar1_nume = $_POST['semnatar1_nume'] ?? '';
$semnatar1_functie = $_POST['semnatar1_functie'] ?? '';
$semnatar2_nume = $_POST['semnatar2_nume'] ?? '';
$semnatar2_functie = $_POST['semnatar2_functie'] ?? '';

// Create new PDF document
$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// Set document information
$pdf->SetCreator('Zapp - Generator Proces Verbal');
$pdf->SetAuthor('Zapp');
$pdf->SetTitle('Proces Verbal - ' . $tipul_procesului);
$pdf->SetSubject('Proces Verbal');

// Set default header data
$pdf->SetHeaderData('', 0, 'PROCES VERBAL', 'Generator Zapp');

// Set header and footer fonts
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

// Set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// Set margins
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

// Set auto page breaks
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

// Set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// Add a page
$pdf->AddPage();

// Set font
$pdf->SetFont('helvetica', '', 12);

// Add logo if exists
$logoPath = 'assets/logo.png';
if (file_exists($logoPath)) {
    $pdf->Image($logoPath, 15, 15, 30, '', 'PNG', '', 'T', false, 300, '', false, false, 0, false, false, false);
}

// Title
$pdf->SetFont('helvetica', 'B', 16);
$pdf->SetY(50);
$pdf->Cell(0, 10, 'PROCES VERBAL', 0, 1, 'C');

// Document info
$pdf->SetFont('helvetica', '', 12);
$pdf->Ln(10);

// Date and time
$pdf->Cell(0, 8, 'Data: ' . date('d.m.Y', strtotime($data)), 0, 1);
$pdf->Cell(0, 8, 'Ora: ' . $ora, 0, 1);
$pdf->Cell(0, 8, 'Locul: ' . $locul, 0, 1);
$pdf->Ln(5);

// Process type and object
$pdf->SetFont('helvetica', 'B', 12);
$pdf->Cell(0, 8, 'Tipul procesului: ' . $tipul_procesului, 0, 1);
$pdf->SetFont('helvetica', '', 12);
$pdf->Cell(0, 8, 'Obiectul: ' . $obiectul, 0, 1);
$pdf->Ln(5);

// Participants
$pdf->SetFont('helvetica', 'B', 12);
$pdf->Cell(0, 8, 'Participanți:', 0, 1);
$pdf->SetFont('helvetica', '', 12);
$pdf->MultiCell(0, 8, $participanti, 0, 'L', false, 1, '', '', true, 0, false, true, 0, 'T', false);
$pdf->Ln(5);

// Conclusions
$pdf->SetFont('helvetica', 'B', 12);
$pdf->Cell(0, 8, 'Concluzii și observații:', 0, 1);
$pdf->SetFont('helvetica', '', 12);
$pdf->MultiCell(0, 8, $concluzii, 0, 'L', false, 1, '', '', true, 0, false, true, 0, 'T', false);
$pdf->Ln(15);

// Signature area
$pdf->SetFont('helvetica', 'B', 12);
$pdf->Cell(0, 8, 'Semnături:', 0, 1);
$pdf->Ln(5);

// First signature
$pdf->SetFont('helvetica', '', 10);
$pdf->Cell(80, 8, 'Semnătura:', 0, 0, 'L');
$pdf->Cell(80, 8, 'Semnătura:', 0, 1, 'L');
$pdf->Ln(20);

// Signature lines
$pdf->Line(20, $pdf->GetY(), 100, $pdf->GetY());
$pdf->Line(110, $pdf->GetY() - 20, 190, $pdf->GetY() - 20);

// Signature names and functions
$pdf->SetY($pdf->GetY() - 15);
$pdf->Cell(80, 8, $semnatar1_nume, 0, 0, 'C');
$pdf->Cell(80, 8, $semnatar2_nume, 0, 1, 'C');

$pdf->Cell(80, 8, $semnatar1_functie, 0, 0, 'C');
$pdf->Cell(80, 8, $semnatar2_functie, 0, 1, 'C');

// Add some space for manual signatures
$pdf->Ln(10);
$pdf->SetFont('helvetica', 'I', 8);
$pdf->Cell(0, 8, 'Nota: Semnăturile de mai sus sunt pentru identificare. Semnăturile fizice vor fi adăugate manual pe documentul imprimat.', 0, 1, 'C');

// Add a signature box for manual signing
$pdf->Ln(10);
$pdf->SetFont('helvetica', 'B', 10);
$pdf->Cell(0, 8, 'ZONA PENTRU SEMNĂTURI MANUALE:', 0, 1, 'C');
$pdf->Ln(5);

// Create signature boxes
$signatureY = $pdf->GetY();
$boxHeight = 40;

// First signature box
$pdf->Rect(20, $signatureY, 80, $boxHeight);
$pdf->SetXY(20, $signatureY + 5);
$pdf->SetFont('helvetica', '', 8);
$pdf->Cell(80, 8, 'Semnătură: ' . $semnatar1_nume, 0, 1, 'C');
$pdf->SetXY(20, $signatureY + 15);
$pdf->Cell(80, 8, $semnatar1_functie, 0, 1, 'C');
$pdf->SetXY(20, $signatureY + 25);
$pdf->Cell(80, 8, 'Data: _______________', 0, 1, 'C');

// Second signature box (if second signer exists)
if (!empty($semnatar2_nume)) {
    $pdf->Rect(110, $signatureY, 80, $boxHeight);
    $pdf->SetXY(110, $signatureY + 5);
    $pdf->Cell(80, 8, 'Semnătură: ' . $semnatar2_nume, 0, 1, 'C');
    $pdf->SetXY(110, $signatureY + 15);
    $pdf->Cell(80, 8, $semnatar2_functie, 0, 1, 'C');
    $pdf->SetXY(110, $signatureY + 25);
    $pdf->Cell(80, 8, 'Data: _______________', 0, 1, 'C');
}

// Footer
$pdf->SetY(-30);
$pdf->SetFont('helvetica', 'I', 8);
$pdf->Cell(0, 8, 'Document generat automat de Generator Proces Verbal Zapp - ' . date('d.m.Y H:i'), 0, 1, 'C');

// Generate filename
$filename = 'Proces_Verbal_' . $tipul_procesului . '_' . date('Y-m-d_H-i') . '.pdf';

// Output PDF
$pdf->Output($filename, 'D'); // 'D' for download
?>
