# Generator Proces Verbal - Zapp

Aplicație PHP pentru generarea proceselor verbale cu zonă de semnare.

## Structura proiectului

```
pv_app_php/
├── composer.json          # Dependențe PHP
├── vendor/                # Biblioteci generate de Composer
├── public/
│   ├── index.php          # Formular pentru introducerea datelor
│   ├── generate.php       # Generator PDF cu zonă de semnare
│   └── assets/
│       ├── logo.png       # Logo Zapp (de adăugat)
│       └── logo_placeholder.txt  # Instrucțiuni pentru logo
└── README.md              # Documentația proiectului
```

## Instalare

1. **Instalare dependențe:**
   ```bash
   composer install
   ```

2. **Adăugare logo:**
   - Înlocuiți fișierul `public/assets/logo_placeholder.txt` cu logo-ul Zapp
   - Numele fișierului trebuie să fie `logo.png`
   - Format recomandat: PNG, 100x100 pixeli, fundal transparent

3. **Configurare server web:**
   - Punctați document root-ul către directorul `public/`
   - Asigurați-vă că PHP 7.4+ este instalat

## Utilizare

1. **Accesați formularul:**
   - Deschideți `http://localhost/public/index.php` în browser

2. **Completați datele:**
   - Data și ora procesului verbal
   - Locul desfășurării
   - Tipul procesului (inventar, control, audit, etc.)
   - Obiectul procesului verbal
   - Lista participanților
   - Concluzii și observații
   - Datele semnatarilor

3. **Generați PDF-ul:**
   - Apăsați butonul "Generează Procesul Verbal PDF"
   - PDF-ul va fi descărcat automat cu numele format: `Proces_Verbal_[tip]_[data_ora].pdf`

## Caracteristici

### Formular modern și responsive
- Design modern cu gradient și animații
- Responsive pentru toate dispozitivele
- Validare client-side și server-side
- Completare automată a datei și orei curente

### Generator PDF avansat
- Folosește biblioteca TCPDF pentru generarea PDF-urilor
- Include logo-ul Zapp în header
- Formatare profesională a documentului
- Zonă dedicată pentru semnături

### Zonă de semnare
- **Semnături digitale:** Numele și funcțiile semnatarilor sunt incluse în PDF
- **Zonă pentru semnături manuale:** Căsuțe dedicate pentru semnătura fizică
- **Flexibilitate:** Suportă 1 sau 2 semnături
- **Instrucțiuni clare:** Note explicative pentru semnătura manuală

## Dependențe

- **PHP 7.4+**
- **Composer**
- **TCPDF 6.4+** - pentru generarea PDF-urilor

## Configurare server

### Apache
```apache
<VirtualHost *:80>
    DocumentRoot /path/to/pv_app_php/public
    ServerName pv-app.local
</VirtualHost>
```

### Nginx
```nginx
server {
    listen 80;
    server_name pv-app.local;
    root /path/to/pv_app_php/public;
    index index.php;
    
    location ~ \.php$ {
        fastcgi_pass unix:/var/run/php/php7.4-fpm.sock;
        fastcgi_index index.php;
        include fastcgi_params;
    }
}
```

## Dezvoltare

### Structura codului
- `public/index.php` - Formular HTML cu stilizare CSS modernă
- `public/generate.php` - Logica de generare PDF cu TCPDF
- `composer.json` - Configurare dependențe și autoload

### Personalizare
- **Logo:** Înlocuiți `public/assets/logo.png`
- **Culori:** Modificați variabilele CSS în `public/index.php`
- **Format PDF:** Ajustați parametrii TCPDF în `public/generate.php`

## Securitate

- Validare input pe server
- Sanitizare date înainte de procesare
- Protecție împotriva XSS
- Verificare tip de fișier pentru logo

## Suport

Pentru întrebări sau probleme, contactați echipa de dezvoltare Zapp.

## Licență

Proprietate Zapp - Toate drepturile rezervate.
